
### Installation
1. Install the required packages: diffusers, accelerate
   ```sh
   pip install torch torchvision diffusers accelerate einops easydict pytorch_lightning
   ```
### Code Usage

#### Download pre-trained models

#### Generate DNA sequences using the trained diffusion model

Set the path to the pretrained vae model and unet model in the following command. The number of sequences to generate can be set using the sequence_num argument in ```src/configs/generate.yaml```.

```
CUDA_VISIBLE_DEVICES="0" accelerate launch --main_process_port 12903 --multi_gpu main.py --model generate --gen_vae_path="" --gen_unet_path=""
```


#### Train the diffusion model

Set the path to the dataset in the config file ```src/configs/un_unet.yaml``` data_path field.
Set the path to the pretrained vae model in the config file ```src/configs/un_unet.yaml``` vae_path field.
```
CUDA_VISIBLE_DEVICES="0,1" accelerate launch --main_process_port 12903 --multi_gpu main.py --model un_unet
```

#### Train the vae model

Set the path to the dataset in the config file
```
CUDA_VISIBLE_DEVICES="0,1" accelerate launch --main_process_port 12903 --multi_gpu main.py --model vanilla_vae
```
